<!-- @file Project Page -->
# Bootstrap

> Sleek, intuitive, and powerful mobile first front-end framework for faster and
> easier web development. Bootstrap has become one of the most popular front-end
> frameworks and open source projects in the world.

This base theme bridges the gap between Drupal and the [Bootstrap Framework].

### Features
- [jsDelivr CDN](https://www.jsdelivr.com) for "out-of-the-box" styling and
  faster page load times.
- [Bootswatch](http://bootswatch.com) theme support, if using the CDN.
- Glyphicons support via [Icon API](https://www.drupal.org/project/icon).
- Extensive integration and template/preprocessor overrides for most of the
  [Bootstrap Framework] CSS, Components and JavaScript
- Theme settings to further enhance the Drupal Bootstrap integration:
  - [Breadcrumbs](https://getbootstrap.com/docs/3.4/components/#breadcrumbs)
  - [Navbar](https://getbootstrap.com/docs/3.4/components/#navbar)
  - [Popovers](https://getbootstrap.com/docs/3.4/javascript/#popovers)
  - [Tooltips](https://getbootstrap.com/docs/3.4/javascript/#tooltips)
  - [Wells](https://getbootstrap.com/docs/3.4/components/#wells) (per region)

### Documentation
Visit the project's [official documentation site](https://drupal-bootstrap.org)
or the markdown files inside the `./docs` folder.

[Bootstrap Framework]: https://getbootstrap.com/docs/3.4/
