# Contributing to farmOS

There are many ways to get involved in the farmOS community. You don't need to
be a programmer. All are welcome to take part in the process.

## Use farmOS

First and foremost: use farmOS.

Building a critical mass of farmOS users is the best way for the project to
grow and thrive. If you would like to improve your
farming/gardening/agricultural record keeping habits, or just want a place to
put everything so you can access it easily, farmOS can help. Tell the farmers
you know about farmOS and - if you have a social media presence - help tell the
world about farmOS!

## Questions, Feature requests, Bug reports, etc

If you have questions, ideas for new features, or if you find bugs, you can
can start a public thread to discuss/develop/debug them.

*farmOS comprises multiple projects and modules, across different codebases,
each with their own issue queues and roadmaps, so if you are unsure where to
put something, follow these guidelines.*

**Questions**, **support requests**, and **general discussions** should be in
the [farmOS Forum](https://farmOS.discourse.group).

**Bug reports** can be posted to the
[farmOS issue queue on GitHub](https://github.com/farmOS/farmOS/issues).
Issues in this queue will be triaged and moved or copied into the appropriate
issue queues for the code responsible for them.

**Feature requests** should start in the forum most of the time. Developers
and other community members can discuss the idea and decide where it makes
sense to build it. In many cases, new features can be built as standalone
modules or apps, and don't need to be part of the farmOS code itself. This
modular and API-driven approach to development allows for experimentation and
innovation in the "contrib" space. If the feature request requires core farmOS
feature(s) to be built, issues for each specific piece can be created in the
appropriate project issue queues and added to their respective roadmaps.

**Core development** issues and roadmaps are managed on Drupal.org in the
[farmOS Project](https://drupal.org/project/farm) issue queue:
[https://drupal.org/project/issues/farm](https://drupal.org/project/issues/farm)

## Live Discussions

The [farmOS Forum](https://farmOS.discourse.gorup) is a great place for ongoing
discussions, sharing workflow ideas, support requests, etc, but sometimes it's
necessary to talk to someone in real time.

The farmOS community hosts a monthly call on the second Wednesday of the month.
Often these calls are free-form "office hours" to get support or discuss ideas,
and sometimes they have a specific agenda or focus. The link and call schedule
are available on farmOS.org:

**[farmOS Monthly Call](https://farmOS.org/community/monthly-call)**

A farmOS chat room is available on both Matrix.org and IRC. The two rooms are
bridged so that chats are synced between them. Both platforms require a
registered username to participate.

**[#farmOS room on Matrix.org](https://app.element.io/#/room/#farmOS:matrix.org)**

**[#farmOS IRC channel on Freenode](http://webchat.freenode.net/?channels=#farmOS)**

## Documentation, Tutorials, Presentations, etc

One of the best ways to help is by helping others. New users learn farmOS by
reading the [farmOS User Guide](https://farmOS.org/guide), browsing posts in
the [farmOS Forum](https://farmOS.discourse.group), and by watching/attending
videos and presentations. Lending a hand in any of these areas is a great way
to give back to the community. If there is a local farming conference near you,
consider giving a presentation to the farmers that attend. Or, if you have a
YouTube channel or other social platform, consider sharing your experiences and
farmOS workflows with others.

## Translations

farmOS is used around the world, and is actively being translated into many
languages. The robust localization features and infrastructure provided by
[localize.drupal.org](https://localize.drupal.org) are used to support these
efforts.

## Donations and Sponsorship

The farmOS project accepts donations through Open Source Collective, a 501c(6)
Non-Profit. These funds go towards community infrastructure, outreach, and
other ongoing expenses. You can become a backer of the project with a small
monthly donation, or just chip in what you want.

**[Donate to farmOS](https://farmOS.org/donate)**
